//AIM:Design of IIR filter.
//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
//We will design the digital high pass filter for cut off frequency of 30Hz and 
//sampling frequency of 150Hz using Bilinear transformation
//Part 1 : Calculation of specification for digital filter 
Fhp=30;//given cut off frequency is 30 Hz
Fs=150;//given sampling frequency is 150 Hz
fhp=Fhp/Fs;
disp(fhp,'fhp=')
omegahp=2*%pi*fhp;
disp(omegahp,'omegahp=')
//order of the filter is not given so we assume N=1
N=1
//Part 2 ; Calulation of specifications of analog filter
//Ts is not given directly so we calculate using formula Ts=1/Fs
Ts=1/Fs;
disp(Ts,'Ts=');
//Step 1: calulation of Ωhp
ohmhp=(2/Ts)*tan(omegahp/2);
disp(ohmhp,"The calulated value of Ωhp in rad/sec=");
//transfer function for low pass filter is H(s)=1/(s-s1)
//since it is low pass filter s1=(-1)
s=poly(0,"s");
S=poly(0,"S");
H=1/(s+1);
//part 3 : Use frequency transformation
ohmc=1;
s=(ohmc*ohmhp)/S;
H1=1/(s+1)
disp(H1,"Transfer function of the analog high pass filter H(s)=");
//Part 4: Calculation of H(z)for digital filter
Z=poly(0,"Z");
s=(ohmc*ohmhp)/((2/Ts)*((Z-1)/(Z+1)));
H2=1/(s+1);
disp(H2,"Transfer function of the digital filter H(z)=")

//Expected output:
//Transfer function of the digital filter                                
//               - 300 + 300Z 
//  H(z)=    ----------------------     
//          - 82.037242 + 517.96276Z  
   
         
